﻿Module CtrlCard
    '****************************运动控制模块 **************************

    '为了简单、方便、快捷地开发出通用性好、可扩展性强、

    '维护方便的应用系统，我们在控制卡函数库的基础上将

    '所有库函数进行了分类封装。下面的示例使用一块运动

    '控制卡

    '*******************************************************************
    Public Result As Int32      '返回值

    Public gCardIndex As Int32    '卡号

    Const MULTIPLE = 5           '倍率

    Const MAXAXIS = 4           '最大轴数

    '******************************初始化函数***************************

    '该函数中包含了控制卡初始化常用的库函数，这是调用

    '其他函数的基础，所以必须在示例程序中最先调用

    '返回值<=0表示初始化失败，返回值>0表示初始化成功

    '*******************************************************************
    Public Function Init_Card() As Int32

        Result = adt8949_initial           '卡初始化
        Dim i As Int32
        If Result <= 0 Then

            Init_Card = Result

            Exit Function

        End If

        For i = 1 To MAXAXIS

            adt8949_set_command_pos(gCardIndex, i, 0)               '逻辑位置计数器清零

            adt8949_set_actual_pos(gCardIndex, i, 0)                '实位位置计数器清零

            adt8949_set_startv(gCardIndex, i, 1000)                 '设置初始速度

            adt8949_set_speed(gCardIndex, i, 1000)                  '设置驱动速度

            adt8949_set_acc(gCardIndex, i, 625)                     '设置加速度

        Next i

        Init_Card = Result

    End Function

    '***************************功能:设置速度模块***********************

    '   依据参数的值，判断是匀速还是加减速

    '    设置范围，是决定倍率的参数

    '    设置轴的初始速度、驱动速度和加速度

    '    参数:       axis -轴号

    '              startV -初始速度

    '               Speed -驱动速度

    '               add -加速度

    '              dec -减速度

    '               ratio -倍率

    '    返回值=0正确，返回值=1错误

    '*******************************************************************
    Public Function Setup_Speed(ByVal axis As Int32, ByVal startv As Single, ByVal speedv As Single, ByVal acc As Single, ByVal dec As Single, ByVal mode As UInt16) As Int32
        '设定齿轮比 齿轮比放在refresh函数中
        '设定倍率  默认的倍率是1
        If startv > speedv Then
            adt8949_set_startv(gCardIndex, axis, startv)
            adt8949_set_speed(gCardIndex, axis, speedv)
        Else
            Result = adt8949_set_admode(gCardIndex, axis, mode)  '设定加速模式
            adt8949_set_startv(gCardIndex, axis, startv) '设定初始速度
            adt8949_set_speed(gCardIndex, axis, speedv) '设定驱动速度
            adt8949_set_acc(gCardIndex, axis, acc) '设定加速度

            If MianForm.m_decFlag = 1 Then  '加速度一定要设置到减速度的前面，不然加速度会覆盖减速度
                adt8949_set_dec(gCardIndex, axis, dec)
            End If
        End If

    End Function

    '************************功能：停止驱动函数*************************

    '该函数用于停止驱动，分为立即停止和减速停止

    '参数: axis-轴号，mode: 0-立即停止，1-减速停止

    '返回值=0正确，返回值=1错误

    '*******************************************************************
    Public Function StopRun(ByVal axis As Int32, ByVal mode As Int32) As Int32

        If mode = 0 Then             '立即停止

            Result = adt8949_sudden_stop(gCardIndex, axis)

        Else                         '减速停止

            Result = adt8949_dec_stop(gCardIndex, axis)

        End If

    End Function


    '****************************获取运动状态函数***********************

    '该函数用于获取各轴的驱动状态和插补的驱动状态

    '参数: axis-轴号，value-状态(0-驱动结束，非0-正在驱动)

    'mode 0-获取单轴的驱动状态，非0-获取插补的驱动状态

    '返回值=0正确，返回值=1错误

    '*******************************************************************
    Public Function Get_MoveStatus(ByVal axis As Int32, ByRef Value As Int32, ByVal mode As Int32) As Int32

        If mode = 0 Then         '获取单轴驱动状态

            Get_MoveStatus = adt8949_get_status(gCardIndex, axis, Value)

        Else                     '获取插补驱动状态

            Get_MoveStatus = adt8949_get_inp_status(gCardIndex, Value)

        End If

    End Function

    '************************设置位置计数器函数*************************

    '该函数用于设置逻辑位置和实际位置

    '参数: axis-轴号，pos-位置设置值

    '      mode： 0 - 设置逻辑位置      1 - 设置实际位置

    '返回值 = 0正确， 返回值 = 1错误

    '*******************************************************************
    Public Function Setup_Pos(ByVal axis As Int32, ByVal pos As Int32, ByVal mode As Int32) As Int32

        If mode = 0 Then

            Result = adt8949_set_command_pos(gCardIndex, axis, pos)

        Else

            Result = adt8949_set_actual_pos(gCardIndex, axis, pos)

        End If

    End Function

    '************************获取运动信息***********************
    '该函数用于反馈轴当前的逻辑位置，实际位置和运行速度
    '参数: axis -轴号, LogPos - 逻辑位置, actpos - 实际位置, speed - 运行速度
    '返回值=0正确，返回值=1错误
    '***********************************************************/
    Public Function Get_CurrentInf(ByVal axis As Int32, ByRef LogPos As Int32, ByRef ActPos As Int32, ByRef speed As Int32) As Int32

        Result = adt8949_get_command_pos(gCardIndex, axis, LogPos)

        adt8949_get_actual_pos(gCardIndex, axis, ActPos)

        adt8949_get_speed(gCardIndex, axis, speed)

        Get_CurrentInf = Result

    End Function

    '消息出来函数，防止卡屏
    Public Function DoEvents() As Int32
        Windows.Forms.Application.DoEvents()
    End Function

    '睡眠函数 
    Public Function sleep(ByVal msec As Int32) As Int32
        System.Threading.Thread.Sleep(msec)
    End Function

End Module
